// DialogBasicMoveDlg.cpp : implementation file
//

#include "stdafx.h"
#include "8949G1VC.h"
#include "DialogBasicMoveDlg.h"
#include "CtrlCardSingletion.h"
CDialogBasicMoveDlg *BasicMove;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDialogBasicMoveDlg dialog


BOOL m_Bdec = false;

CDialogBasicMoveDlg::CDialogBasicMoveDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogBasicMoveDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogBasicMoveDlg)
	m_bX = FALSE;
	m_bY = FALSE;
	m_bZ = FALSE;
	m_bA = FALSE;
	m_fStartvX = 10;
	m_fStartvY = 10;
	m_fStartvZ = 10;
	m_fStartvA = 10;
	m_fSpeedX = 40;
	m_fSpeedY = 40;
	m_fSpeedZ = 40;
	m_fSpeedA = 40;
	m_fAddX = 50;
	m_fAddY = 50;
	m_fAddZ = 50;
	m_fAddA = 50;
	m_fPulseX = 50;
	m_fPulseY = 50;
	m_fPulseZ = 50;
	m_fPulseA = 50;
	m_fDecX = 50;
	m_fDecY = 50;
	m_fDecZ = 50;
	m_fDecA = 50;
	m_nYADMode = 1;
	m_nZADMode = 1;
	m_nXADMode = 1;
	m_fGearX = 1000.0f;
	m_fGearY = 1000.0f;
	m_fGearZ = 1000.0f;
	m_fGearA = 1000.0f;
	m_fSpeedINP = 40.0f;
	m_fAddINP = 500.0f;
	m_fDecINP = 500.0f;
	m_fPulseINP = 0.0f;
	m_fSartINP = 10.0f;
	m_nAdmodeINP = 1;
	m_nAADMode = 1;
	m_bDec = FALSE;

	//}}AFX_DATA_INIT
}


void CDialogBasicMoveDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogBasicMoveDlg)
	DDX_Check(pDX, IDC_CHECK_BASICMOVE_X, m_bX);
	DDX_Check(pDX, IDC_CHECK_BASICMOVE_Y, m_bY);
	DDX_Check(pDX, IDC_CHECK_BASICMOVE_Z, m_bZ);
	DDX_Check(pDX, IDC_CHECK_BASICMOVE_A, m_bA);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_STARTV_X, m_fStartvX);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_STARTV_Y, m_fStartvY);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_STARTV_Z, m_fStartvZ);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_STARTV_A, m_fStartvA);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_SPEED_X, m_fSpeedX);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_SPEED_Y, m_fSpeedY);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_SPEED_Z, m_fSpeedZ);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_SPEED_A, m_fSpeedA);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_ADD_X, m_fAddX);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_ADD_Y, m_fAddY);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_ADD_Z, m_fAddZ);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_ADD_A, m_fAddA);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_PULSE_X, m_fPulseX);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_PULSE_Y, m_fPulseY);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_PULSE_Z, m_fPulseZ);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_PULSE_A, m_fPulseA);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_DEC_X, m_fDecX);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_DEC_Y, m_fDecY);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_DEC_Z, m_fDecZ);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_DEC_A, m_fDecA);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_IDC_EDIT_BASICMOVE_YADMODE, m_nYADMode);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_IDC_EDIT_BASICMOVE_ZADMODE, m_nZADMode);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_XADMODE, m_nXADMode);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_XGEAR, m_fGearX);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_YGEAR, m_fGearY);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_ZGEAR, m_fGearZ);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_AGEAR, m_fGearA);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_SPEED_INP, m_fSpeedINP);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_ADD_INP, m_fAddINP);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_DEC_INP, m_fDecINP);


	DDX_Text(pDX, IDC_EDIT_BASICMOVE_STARTV_INP, m_fSartINP);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_IDC_EDIT_BASICMOVE_AADMODEINP, m_nAdmodeINP);
	DDX_Text(pDX, IDC_EDIT_BASICMOVE_IDC_EDIT_BASICMOVE_AADMODE, m_nAADMode);
	DDX_Check(pDX, IDC_CHECK_DEC, m_bDec);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialogBasicMoveDlg, CDialog)
	//{{AFX_MSG_MAP(CDialogBasicMoveDlg)
	ON_BN_CLICKED(IDC_BUTTON_PMOVE, OnButtonPmove)
	ON_BN_CLICKED(IDC_BUTTON_BASICMOVE_INTERUPMOVE, OnButtonBasicmoveInterupmove)

	ON_BN_CLICKED(IDC_CHECK_DEC, OnCheckDec)

	ON_BN_CLICKED(IDC_BUTTON_PMOVE2, OnButtonPmove2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogBasicMoveDlg message handlers

BOOL CDialogBasicMoveDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	BasicMove = this;
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDialogBasicMoveDlg::SelectAxis() 
{

}

void CDialogBasicMoveDlg::OnButtonPmove() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);

	
	adt8949_set_gear(g_cardID,1,m_fGearX);
	adt8949_set_gear(g_cardID,2,m_fGearY);
	adt8949_set_gear(g_cardID,3,m_fGearZ);
	adt8949_set_gear(g_cardID,4,m_fGearA);

	
	if (m_bX)
	{
	
		CCtrlCardSingletion::Instance()->SetupSpeed(1, m_fStartvX, m_fSpeedX, m_fAddX,m_fDecX,m_nXADMode);
		CCtrlCardSingletion::Instance()->AxisPmove(1, m_fPulseX);

	}
	if (m_bY)
	{
		
		CCtrlCardSingletion::Instance()->SetupSpeed(2, m_fStartvY, m_fSpeedY, m_fAddY,m_fDecY,m_nYADMode);
		CCtrlCardSingletion::Instance()->AxisPmove(2, m_fPulseY);
	}

	if (m_bZ)
	{
		
		CCtrlCardSingletion::Instance()->SetupSpeed(3, m_fStartvZ, m_fSpeedZ, m_fAddZ,m_fDecZ,m_nZADMode);
		CCtrlCardSingletion::Instance()->AxisPmove(3, m_fPulseZ);
	}
	if (m_bA)
	{
		
		CCtrlCardSingletion::Instance()->SetupSpeed(4, m_fStartvA, m_fSpeedA, m_fAddA,m_fDecA,m_nAADMode);
		CCtrlCardSingletion::Instance()->AxisPmove(4, m_fPulseA);
	}
}


void CDialogBasicMoveDlg::OnButtonPmove2() 
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
	



	
	adt8949_set_gear(g_cardID,1,m_fGearX);
	adt8949_set_gear(g_cardID,2,m_fGearY);
	adt8949_set_gear(g_cardID,3,m_fGearZ);
	adt8949_set_gear(g_cardID,4,m_fGearA);
	
	
	if (m_bX)
	{
		
		CCtrlCardSingletion::Instance()->SetupSpeed(1, m_fStartvX, m_fSpeedX, m_fAddX,m_fDecX,m_nXADMode);
		CCtrlCardSingletion::Instance()->AxisPmove(1, -m_fPulseX);
		
	}
	if (m_bY)
	{
		
		CCtrlCardSingletion::Instance()->SetupSpeed(2, m_fStartvY, m_fSpeedY, m_fAddY,m_fDecY,m_nYADMode);
		CCtrlCardSingletion::Instance()->AxisPmove(2, -m_fPulseY);
	}
	
	if (m_bZ)
	{
		
		CCtrlCardSingletion::Instance()->SetupSpeed(3, m_fStartvZ, m_fSpeedZ, m_fAddZ,m_fDecZ,m_nZADMode);
		CCtrlCardSingletion::Instance()->AxisPmove(3, -m_fPulseZ);
	}
	if (m_bA)
	{
		
		CCtrlCardSingletion::Instance()->SetupSpeed(4, m_fStartvA, m_fSpeedA, m_fAddA,m_fDecA,m_nAADMode);
		CCtrlCardSingletion::Instance()->AxisPmove(4, -m_fPulseA);
	}
}


void CDialogBasicMoveDlg::OnButtonBasicmoveInterupmove() 
{
	// TODO: Add your control notification handler code here
	UpdateData();


	
	if(!m_bX && !m_bY && !m_bZ && !m_bA)
	{
		MessageBox("please select the interpolation axis!","tips");
		return;
	}

	adt8949_set_gear(g_cardID,1,m_fGearX);
	adt8949_set_gear(g_cardID,2,m_fGearY);
	adt8949_set_gear(g_cardID,3,m_fGearZ);
	adt8949_set_gear(g_cardID,4,m_fGearA);

	CCtrlCardSingletion::Instance()->SetupSpeed(INPA_AXISREG, m_fSartINP, m_fSpeedINP, m_fAddINP,m_fDecINP,m_nAdmodeINP);

	
	if (m_bX && !m_bY && !m_bZ && !m_bA)	// XY岹
	{
		
		CCtrlCardSingletion::Instance()->InterpMove1(1,  m_fPulseX);
		
	}
	else if (!m_bX && m_bY && !m_bZ && !m_bA)	// XZ岹
	{
		
		CCtrlCardSingletion::Instance()->InterpMove1(2,  m_fPulseY);
	}
	else if (!m_bX && !m_bY && m_bZ && !m_bA)	// XA岹
	{
		CCtrlCardSingletion::Instance()->InterpMove1(3, m_fPulseZ);
	}
	else if (!m_bX && !m_bY && !m_bZ && m_bA)	// YZ岹
	{
		
		CCtrlCardSingletion::Instance()->InterpMove1(4, m_fPulseA);
	}
	
	// 岹
	if (m_bX && m_bY && !m_bZ && !m_bA)	// XY岹
	{
		
		CCtrlCardSingletion::Instance()->InterpMove2(1, 2, m_fPulseX, m_fPulseY);
		
	}
	else if (m_bX && !m_bY && m_bZ && !m_bA)	// XZ岹
	{
		
		CCtrlCardSingletion::Instance()->InterpMove2(1, 3, m_fPulseX, m_fPulseZ);
	}
	else if (m_bX && !m_bY && !m_bZ && m_bA)	// XA岹
	{
		CCtrlCardSingletion::Instance()->InterpMove2(1, 4, m_fPulseX, m_fPulseA);
	}
	else if (!m_bX && m_bY && m_bZ && !m_bA)	// YZ岹
	{
		
		CCtrlCardSingletion::Instance()->InterpMove2(2, 3, m_fPulseY, m_fPulseZ);
	}
	else if (!m_bX && m_bY && !m_bZ && m_bA)	// YA岹
	{		
		CCtrlCardSingletion::Instance()->InterpMove2(2, 4, m_fPulseY, m_fPulseA);
	}
	else if (!m_bX && !m_bY && m_bZ && m_bA)	// ZA岹
	{
		
		CCtrlCardSingletion::Instance()->InterpMove2(3, 4, m_fPulseZ, m_fPulseA);
	}
	
	//////////////////////////////////////////////////////////////////////////
	// 岹
	if (m_bX && m_bY && m_bZ && !m_bA)		// XYZ岹
	{
		CCtrlCardSingletion::Instance()->InterpMove3(1, 2, 3, m_fPulseX, m_fPulseY, m_fPulseZ);
		
	}
	else if (m_bX && m_bY && !m_bZ && m_bA)	// XYA岹
	{
		CCtrlCardSingletion::Instance()->InterpMove3(1, 2, 4, m_fPulseX, m_fPulseY, m_fPulseA);
	}
	else if (m_bX && !m_bY && m_bZ && m_bA)	// XZA岹		
	{
		CCtrlCardSingletion::Instance()->InterpMove3(1, 3, 4, m_fPulseX, m_fPulseY, m_fPulseZ);
	}
	else if (!m_bX && m_bY && m_bZ && m_bA)	// YZA岹
	{
		CCtrlCardSingletion::Instance()->InterpMove3(2, 3, 4, m_fPulseY, m_fPulseZ, m_fPulseA);
	}
	
	//////////////////////////////////////////////////////////////////////////
	// 岹
	if (m_bX && m_bY && m_bZ && m_bA)		// XYZA岹
	{
		CCtrlCardSingletion::Instance()->InterpMove4(m_fPulseX, m_fPulseY, m_fPulseZ, m_fPulseA);
	}
	
	

}



void CDialogBasicMoveDlg::OnCheckDec() 
{
	// TODO: Add your control notification handler code here
	if(((CButton*)GetDlgItem(IDC_CHECK_DEC))->GetCheck()==1)
	{
       m_Bdec = TRUE;
	   ((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_X))->EnableWindow(TRUE);
	   ((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_Y))->EnableWindow(TRUE);
	   ((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_Z))->EnableWindow(TRUE);
	   ((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_A))->EnableWindow(TRUE);
	   ((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_INP))->EnableWindow(TRUE);
	}
	else
	{
		m_Bdec = FALSE;
		((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_X))->EnableWindow(FALSE);
		((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_Y))->EnableWindow(FALSE);
		((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_Z))->EnableWindow(FALSE);
		((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_A))->EnableWindow(FALSE);
		 ((CEdit*)GetDlgItem(IDC_EDIT_BASICMOVE_DEC_INP))->EnableWindow(FALSE);
	}    
	
}


